IF  EXISTS(
	SELECT 
		1 
	FROM 
		SYS.OBJECTS 
	WHERE 
		NAME LIKE 'UFD_EST_PARAM_COMPRAS_GRUPO_CURVA' AND TYPE = 'TF' )
BEGIN
	DROP FUNCTION UFD_EST_PARAM_COMPRAS_GRUPO_CURVA
END
GO
--SELECT * FROM UFD_EST_PARAM_COMPRAS_GRUPO_CURVA (1,4,70933,0) ORDER BY ORDEM_SIGLA
CREATE FUNCTION [dbo].[UFD_EST_PARAM_COMPRAS_GRUPO_CURVA]  (@CD_EMP   INT,    
															@CD_CTR  INT,    
															@CD_PROD  INT,
															@CD_SIGLA INT)
 RETURNS @RS_RET TABLE (CD_EMP INT,
						CD_CTR INT,
						CD_PROD INT,
						CD_GRUPO_CURVA INT,
						CD_SIGLA INT,
						DS_SIGLA VARCHAR(2),
						ORDEM_SIGLA INT,
						ESEG INT,
						EMAX INT,
						P1 MONEY,
						P2 MONEY,
						P1_SAZ MONEY,
						P2_SAZ MONEY,
						FREVISAOMEDIAF INT,
						PERC_PARETO_ACUMULADO MONEY,
						TP_NIVEL	INT,
						FLAG_NAO_REVISAR_PARETO_AUTO INT,
						VLR_PARAMETRO_ATUAL MONEY,
						DS_GRUPO_PARAMETRO VARCHAR(200),
						FREVISAOCURVA INT)

AS              
BEGIN 
	DECLARE @NIVELMENOR INT 

	 DECLARE @RS_TAB_PARAMETROS TABLE (CD_EMP INT,
						CD_CTR INT,
						CD_PROD INT,
						CD_GRUPO_CURVA INT,
						CD_SIGLA INT,
						DS_SIGLA VARCHAR(2),
						ORDEM_SIGLA INT,
						ESEG INT,
						EMAX INT,
						P1 MONEY,
						P2 MONEY,
						P1_SAZ MONEY,
						P2_SAZ MONEY,
						FREVISAOMEDIAF INT,
						PERC_PARETO_ACUMULADO MONEY,
						TP_NIVEL	INT,
						FLAG_NAO_REVISAR_PARETO_AUTO INT,
						VLR_PARAMETRO_ATUAL MONEY,
						FREVISAOCURVA INT)
	
	DECLARE @TBL_NIVEL TABLE ( TP_NIVEL INT,
						 DS_NIVEL VARCHAR(20))
	INSERT INTO @TBL_NIVEL 
		SELECT 1, 'PRODUTO' UNION
		SELECT 2, 'FAMILIA' UNION
		SELECT 3, 'MARCA' UNION
		SELECT 4, 'FABRICANTE' UNION
		SELECT 5, 'CATEGORIA' UNION
		SELECT 6, 'LINHA'	
IF @CD_SIGLA>0
BEGIN
	INSERT INTO @RS_TAB_PARAMETROS
		SELECT	CD_EMP,
				CD_CTR,
				CD_PROD,
				CD_GRUPO_CURVA,
				CD_SIGLA,
				DS_SIGLA,
				ORDEM_SIGLA,
				ESEG,
				EMAX,
				P1,
				P2,
				P1_SAZ,
				P2_SAZ,
				FREVISAOMEDIAF,
				PERC_PARETO_ACUMULADO,
				TP_NIVEL,
				A.FLAG_NAO_REVISAR_PARETO_AUTO,
				A.VLR_PARAMETRO_ATUAL,
				A.FREVISAOCURVA
		FROM UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES(@CD_EMP,@CD_CTR,@CD_PROD) A
		WHERE	
			CD_SIGLA = @CD_SIGLA
END
ELSE
BEGIN
	INSERT INTO @RS_TAB_PARAMETROS
		SELECT	TOP 1 CD_EMP,
				CD_CTR,
				CD_PROD,
				CD_GRUPO_CURVA,
				CD_SIGLA,
				DS_SIGLA,
				ORDEM_SIGLA,
				ESEG,
				EMAX,
				P1,
				P2,
				P1_SAZ,
				P2_SAZ,
				FREVISAOMEDIAF,
				PERC_PARETO_ACUMULADO,
				TP_NIVEL,
				A.FLAG_NAO_REVISAR_PARETO_AUTO,
				A.VLR_PARAMETRO_ATUAL,
				A.FREVISAOCURVA
		FROM UFD_EST_PARAM_COMPRAS_GRUPO_CURVA_VALORES(@CD_EMP,@CD_CTR,@CD_PROD) A
END 
	INSERT INTO @RS_RET
	SELECT 
		MAX(CD_EMP),
		MAX(CD_CTR),
		MAX(CD_PROD),
		MAX(CD_GRUPO_CURVA),
		CD_SIGLA,
		DS_SIGLA,
		ORDEM_SIGLA,
		MAX(ESEG),
		MAX(EMAX),
		MAX(P1),
		MAX(P2),
		MAX(P1_SAZ),
		MAX(P2_SAZ),
		MAX(FREVISAOMEDIAF),
		MAX(PERC_PARETO_ACUMULADO),
		MAX(TP_NIVEL),	
		FLAG_NAO_REVISAR_PARETO_AUTO,
		VLR_PARAMETRO_ATUAL,
		(CASE WHEN MAX(CD_GRUPO_CURVA) = 0 THEN 
			'SEM GRUPO DE CURVAS(%)'
		ELSE  
			'PARAMETRO DE GRUPO DE CURVAS(%) - TAB: ' + CAST(MAX(CD_GRUPO_CURVA) AS VARCHAR) + ' NIVEL: ' + (SELECT DS_NIVEL FROM @TBL_NIVEL N WHERE N.TP_NIVEL = MAX(T.TP_NIVEL))
		END) AS DS_GRUPO_PARAMETRO,
		FREVISAOCURVA
	FROM @RS_TAB_PARAMETROS t
	GROUP BY
		CD_SIGLA,
		DS_SIGLA,
		ORDEM_SIGLA,
		FLAG_NAO_REVISAR_PARETO_AUTO,
		VLR_PARAMETRO_ATUAL,
		FREVISAOCURVA
		

	DELETE FROM @RS_RET WHERE CD_PROD IS NULL

	SET @NIVELMENOR= ISNULL((SELECT 	
						MIN(TP_NIVEL)
					  FROM	
						@RS_RET),0)
						
	DELETE FROM @RS_RET WHERE TP_NIVEL <> @NIVELMENOR
RETURN
END 